﻿using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	internal class GetAnimalsLocation : AbsWebAPI {
		private readonly List<EntityAnimal> animals = new List<EntityAnimal> ();

		public override void HandleRequest (RequestContext _context) {
			JsonArray animalsJsResult = new JsonArray ();

			Animals.Instance.Get (animals);
			for (int i = 0; i < animals.Count; i++) {
				EntityAnimal entity = animals [i];
				Vector3i position = new Vector3i (entity.GetPosition ());

				JsonObject jsonPOS = new JsonObject ();
				jsonPOS.Add ("x", new JsonNumber (position.x));
				jsonPOS.Add ("y", new JsonNumber (position.y));
				jsonPOS.Add ("z", new JsonNumber (position.z));

				JsonObject pJson = new JsonObject ();
				pJson.Add ("id", new JsonNumber (entity.entityId));

				if (!string.IsNullOrEmpty (entity.EntityName)) {
					pJson.Add ("name", new JsonString (entity.EntityName));
				} else {
					pJson.Add ("name", new JsonString ("animal class #" + entity.entityClass));
				}

				pJson.Add ("position", jsonPOS);

				animalsJsResult.Add (pJson);
			}

			WebUtils.WriteJson (_context.Response, animalsJsResult);
		}
	}
}