using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetPlayerInventories : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			GetPlayerInventory.GetInventoryArguments (_context.Request, out bool showIconColor, out bool showIconName);

			JsonArray allInventoriesResult = new JsonArray ();

			foreach ((PlatformUserIdentifierAbs userId, Player player) in PersistentContainer.Instance.Players.Dict) {
				if (player == null) {
					continue;
				}

				if (player.IsOnline) {
					allInventoriesResult.Add (GetPlayerInventory.DoPlayer (userId.CombinedString, player, showIconColor, showIconName));
				}
			}

			WebUtils.WriteJson (_context.Response, allInventoriesResult);
		}
	}
}