using AllocsFixes.JSON;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetWebMods : AbsWebAPI {
		private readonly JsonArray loadedWebMods = new JsonArray ();

		public GetWebMods (Web _parent) {
			foreach (WebMod webMod in _parent.webMods) {
				JsonObject modJson = new JsonObject ();

				modJson.Add ("name", new JsonString (webMod.ParentMod.ModInfo.Name.Value));
				
				string webModReactBundle = webMod.ReactBundle;
				if (webModReactBundle != null) {
					modJson.Add ("bundle", new JsonString (webModReactBundle));
				}

				string webModCssFile = webMod.CssPath;
				if (webModCssFile != null) {
					modJson.Add ("css", new JsonString (webModCssFile));
				}

				loadedWebMods.Add (modJson);
			}
		}

		public override void HandleRequest (RequestContext _context) {
			WebUtils.WriteJson (_context.Response, loadedWebMods);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}