using System.Collections.Generic;

namespace AllocsFixes.FileCache {
	public abstract class AbstractCache {
		public abstract byte[] GetFileContent (string _filename);
		public abstract (int, int) Invalidate ();

		protected AbstractCache () {
			caches.Add (this);
		}

		private static readonly List<AbstractCache> caches = new List<AbstractCache> ();
		public static (int, int) InvalidateAllCaches () {
			int filesDropped = 0;
			int bytesDropped = 0;
			
			foreach (AbstractCache cache in caches) {
				(int, int) returned = cache.Invalidate ();
				filesDropped += returned.Item1;
				bytesDropped += returned.Item2;
			}

			return (filesDropped, bytesDropped);
		}
	}
}