using System.Collections.Generic;
using JetBrains.Annotations;

namespace AllocsFixes.FileCache {
	[UsedImplicitly]
	public class InvalidateCachesCmd : ConsoleCmdAbstract {
		public override string[] GetCommands () {
			return new[] {"invalidatecaches"};
		}

		public override string GetDescription () {
			return "Invalidate contents of web file caches";
		}

		public override string GetHelp () {
			return "TODO";
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			(int files, int bytes) = AbstractCache.InvalidateAllCaches ();
			SdtdConsole.Instance.Output ($"Caches invalidated, dropped {files} files with {bytes} Bytes");
		}

	}
}