using AllocsFixes.JSON;
using JetBrains.Annotations;

namespace Webserver.WebAPI {
	[UsedImplicitly]
	public class GetAllowedCommands : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			JsonObject result = new JsonObject ();
			JsonArray entries = new JsonArray ();
			foreach (IConsoleCommand cc in SdtdConsole.Instance.GetCommands ()) {
				int commandPermissionLevel = GameManager.Instance.adminTools.GetCommandPermissionLevel (cc.GetCommands ());
				if (_context.PermissionLevel > commandPermissionLevel) {
					continue;
				}

				JsonArray cmdOverloads = new JsonArray ();

				string cmd = string.Empty;
				foreach (string s in cc.GetCommands ()) {
					cmdOverloads.Add (new JsonString (s));
					if (s.Length > cmd.Length) {
						cmd = s;
					}
				}

				JsonObject cmdObj = new JsonObject ();
				cmdObj.Add ("command", new JsonString (cmd));
				cmdObj.Add ("overloads", cmdOverloads);
				cmdObj.Add ("description", new JsonString (cc.GetDescription ()));
				cmdObj.Add ("help", new JsonString (cc.GetHelp ()));
				entries.Add (cmdObj);
			}

			result.Add ("commands", entries);

			WebUtils.WriteJson (_context.Response, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}