using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs {
	[UsedImplicitly]
	public class WebMods : AbsRestApi {
		private readonly byte[] loadedWebMods;

		public WebMods (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginArray ();

			bool first = true;
			foreach (WebMod webMod in _parent.webMods) {
				if (!first) {
					writer.WriteValueSeparator ();
				}
				first = false;
				
				writer.WriteBeginObject ();
				
				writer.WriteString ("name");
				writer.WriteNameSeparator ();
				writer.WriteString (webMod.ParentMod.Name);

				string webModReactBundle = webMod.ReactBundle;
				if (webModReactBundle != null) {
					writer.WriteValueSeparator ();
					writer.WriteString ("bundle");
					writer.WriteNameSeparator ();
					writer.WriteString (webModReactBundle);
				}
				
				string webModCssFile = webMod.CssPath;
				if (webModCssFile != null) {
					writer.WriteValueSeparator ();
					writer.WriteString ("css");
					writer.WriteNameSeparator ();
					writer.WriteString (webModCssFile);
				}
				
				writer.WriteEndObject ();
			}
			
			writer.WriteEndArray ();

			loadedWebMods = writer.ToUtf8ByteArray ();
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (loadedWebMods);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}