using System;
using System.Collections.Generic;
using System.IO;

namespace Webserver.FileCache {
	// Caching all files, useful for completely static folders only
	public class SimpleCache : AbstractCache {
		private readonly Dictionary<string, byte[]> fileCache = new Dictionary<string, byte[]> ();

		public override byte[] GetFileContent (string _filename) {
			try {
				lock (fileCache) {
					if (fileCache.ContainsKey (_filename)) {
						return fileCache [_filename];
					}

					if (!File.Exists (_filename)) {
						return null;
					}

					fileCache.Add (_filename, File.ReadAllBytes (_filename));

					return fileCache [_filename];
				}
			} catch (Exception e) {
				Log.Out ($"Error in SimpleCache.GetFileContent: {e}");
			}

			return null;
		}

		public override (int, int) Invalidate () {
			(int, int) result = (0, 0);
			
			lock (fileCache) {
				result.Item1 = fileCache.Count;
				foreach ((string _, byte[] data) in fileCache) {
					result.Item2 += data.Length;
				}
				
				fileCache.Clear ();
			}

			return result;
		}
	}
}