using Utf8Json;

namespace Webserver.UrlHandlers {
	public class UserStatusHandler : AbsHandler {
		public UserStatusHandler (string _moduleName = null) : base (_moduleName) {
		}

		private static readonly byte[] jsonLoggedInKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("loggedIn");
		private static readonly byte[] jsonUsernameKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("username");
		private static readonly byte[] jsonPermissionsKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("permissions");

		private static readonly byte[] jsonModuleKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("module");
		private static readonly byte[] jsonAllowedKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("allowed");

		public override void HandleRequest (RequestContext _context) {
			WebUtils.PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.WriteRaw (jsonLoggedInKey);
			writer.WriteBoolean (_context.Connection != null);
			
			writer.WriteRaw (jsonUsernameKey);
			writer.WriteString (_context.Connection != null ? _context.Connection.UserId.ToString () : string.Empty);
			
			writer.WriteRaw (jsonPermissionsKey);
			writer.WriteBeginArray ();

			bool first = true;
			foreach (WebPermissions.WebModulePermission perm in WebPermissions.Instance.GetModules ()) {
				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WriteRaw (jsonModuleKey);
				writer.WriteString (perm.module);
				
				writer.WriteRaw (jsonAllowedKey);
				writer.WriteBoolean (perm.permissionLevel >= _context.PermissionLevel);
				
				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();
			
			writer.WriteEndObject ();
			
			WebUtils.SendEnvelopedResult (_context, ref writer);
		}
	}
}