using Utf8Json;

namespace Webserver.WebAPI {
	public static class JsonCommons {
		private static readonly byte[] jsonKeyPositionX = JsonWriter.GetEncodedPropertyNameWithBeginObject ("x");
		private static readonly byte[] jsonKeyPositionY = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("y");
		private static readonly byte[] jsonKeyPositionZ = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("z");

		public static void WritePositionObject (JsonWriter _writer, Vector3i _position) {
			_writer.WriteRaw (jsonKeyPositionX);
			_writer.WriteInt32 (_position.x);
			
			_writer.WriteRaw (jsonKeyPositionY);
			_writer.WriteInt32 (_position.y);
			
			_writer.WriteRaw (jsonKeyPositionZ);
			_writer.WriteInt32 (_position.z);
			
			_writer.WriteEndObject ();
		}
		
	}
}