using System.Collections.Generic;

namespace Webserver.FileCache {
	public abstract class AbstractCache {
		public abstract byte[] GetFileContent (string _filename);
		public abstract (int filesDropped, int bytesDropped) Invalidate ();

		protected AbstractCache () {
			caches.Add (this);
		}

		private static readonly List<AbstractCache> caches = new List<AbstractCache> ();
		public static (int, int) InvalidateAllCaches () {
			int filesDropped = 0;
			int bytesDropped = 0;
			
			foreach (AbstractCache cache in caches) {
				(int files, int bytes) = cache.Invalidate ();
				filesDropped += files;
				bytesDropped += bytes;
			}

			return (filesDropped, bytesDropped);
		}
	}
}