using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs {
	[UsedImplicitly]
	public class ServerInfo : AbsRestApi {
		private static readonly UnityEngine.Profiling.CustomSampler buildSampler = UnityEngine.Profiling.CustomSampler.Create ("JSON_ServerInfo_BuildSampler");

		private static readonly byte[] keyType = JsonWriter.GetEncodedPropertyNameWithBeginObject ("type");
		private static readonly byte[] keyValue = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("value");

		private int largestBuffer;

		protected override void HandleRestGet (RequestContext _context) {
			buildSampler.Begin ();

			PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.EnsureCapacity (largestBuffer);
			writer.WriteBeginObject ();
			
			GameServerInfo gsi = ConnectionManager.Instance.LocalServerInfo;

			bool first = true;
			
			

			foreach (GameInfoString stringGamePref in EnumUtils.Values<GameInfoString> ()) {
				string value = gsi.GetValue (stringGamePref);

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WriteString (stringGamePref.ToStringCached ());
				writer.WriteNameSeparator ();
				
				writer.WriteRaw (keyType);
				writer.WriteString ("string");
				
				writer.WriteRaw (keyValue);
				writer.WriteString (value);
				
				writer.WriteEndObject ();
			}

			foreach (GameInfoInt intGamePref in EnumUtils.Values<GameInfoInt> ()) {
				int value = gsi.GetValue (intGamePref);

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WriteString (intGamePref.ToStringCached ());
				writer.WriteNameSeparator ();
				
				writer.WriteRaw (keyType);
				writer.WriteString ("int");
				
				writer.WriteRaw (keyValue);
				writer.WriteInt32 (value);
				
				writer.WriteEndObject ();
			}

			foreach (GameInfoBool boolGamePref in EnumUtils.Values<GameInfoBool> ()) {
				bool value = gsi.GetValue (boolGamePref);

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WriteString (boolGamePref.ToStringCached ());
				writer.WriteNameSeparator ();
				
				writer.WriteRaw (keyType);
				writer.WriteString ("bool");
				
				writer.WriteRaw (keyValue);
				writer.WriteBoolean (value);
				
				writer.WriteEndObject ();
			}
			
			writer.WriteEndObject ();
			
			buildSampler.End ();

			int bufferContentSize = writer.CurrentOffset + 128;
			if (bufferContentSize > largestBuffer) {
				largestBuffer = bufferContentSize;
			}
			
			SendEnvelopedResult (_context, ref writer);
		}
	}
}