// using AllocsFixes.PersistentData;
// using JetBrains.Annotations;
//
// namespace Webserver.WebAPI.APIs {
// 	[UsedImplicitly]
// 	public class GetPlayersOnline : AbsWebAPI {
// 		public override void HandleRequest (RequestContext _context) {
// 			JsonArray players = new JsonArray ();
//
// 			World w = GameManager.Instance.World;
// 			foreach ((int entityId, EntityPlayer entityPlayer) in w.Players.dict) {
// 				ClientInfo ci = ConnectionManager.Instance.Clients.ForEntityId (entityId);
// 				Player player = PersistentContainer.Instance.Players [ci.InternalId, false];
//
// 				JsonObject pos = new JsonObject ();
// 				pos.Add ("x", new JsonNumber ((int) entityPlayer.GetPosition ().x));
// 				pos.Add ("y", new JsonNumber ((int) entityPlayer.GetPosition ().y));
// 				pos.Add ("z", new JsonNumber ((int) entityPlayer.GetPosition ().z));
//
// 				JsonObject p = new JsonObject ();
// 				p.Add ("steamid", new JsonString (ci.PlatformId.CombinedString));
// 				p.Add ("entityid", new JsonNumber (ci.entityId));
// 				p.Add ("ip", new JsonString (ci.ip));
// 				p.Add ("name", new JsonString (entityPlayer.EntityName));
// 				p.Add ("online", new JsonBoolean (true));
// 				p.Add ("position", pos);
//
// 				p.Add ("level", new JsonNumber (player?.Level ?? -1));
// 				p.Add ("health", new JsonNumber (entityPlayer.Health));
// 				p.Add ("stamina", new JsonNumber (entityPlayer.Stamina));
// 				p.Add ("zombiekills", new JsonNumber (entityPlayer.KilledZombies));
// 				p.Add ("playerkills", new JsonNumber (entityPlayer.KilledPlayers));
// 				p.Add ("playerdeaths", new JsonNumber (entityPlayer.Died));
// 				p.Add ("score", new JsonNumber (entityPlayer.Score));
//
// 				p.Add ("totalplaytime", new JsonNumber (player?.TotalPlayTime ?? -1));
// 				p.Add ("lastonline", new JsonString (player != null ? player.LastOnline.ToString ("s") : string.Empty));
// 				p.Add ("ping", new JsonNumber (ci.ping));
//
// 				players.Add (p);
// 			}
//
// 			WebUtils.WriteJson (_context.Response, players);
// 		}
// 	}
// }