using System.Collections.Generic;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.UrlHandlers {
	public class UserStatusHandler : AbsHandler {
		public UserStatusHandler (string _moduleName = null) : base (_moduleName) {
		}

		private static readonly byte[] jsonLoggedInKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("loggedIn");
		private static readonly byte[] jsonUsernameKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("username");
		private static readonly byte[] jsonPermissionLevelKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("permissionLevel");
		private static readonly byte[] jsonPermissionsKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("permissions");

		private static readonly byte[] jsonModuleKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("module");
		private static readonly byte[] jsonAllowedKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("allowed");

		public override void HandleRequest (RequestContext _context) {
			WebUtils.PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.WriteRaw (jsonLoggedInKey);
			writer.WriteBoolean (_context.Connection != null);
			
			writer.WriteRaw (jsonUsernameKey);
			writer.WriteString (_context.Connection != null ? _context.Connection.Username : string.Empty);
			
			writer.WriteRaw (jsonPermissionLevelKey);
			writer.WriteInt32 (_context.PermissionLevel);
			
			writer.WriteRaw (jsonPermissionsKey);
			writer.WriteBeginArray ();

			List<AdminWebModules.WebModule> list = AdminWebModules.Instance.GetModules ();
			for (int i = 0; i < list.Count; i++) {
				AdminWebModules.WebModule perm = list [i];
				
				if (i > 0) {
					writer.WriteValueSeparator ();
				}

				writer.WriteRaw (jsonModuleKey);
				writer.WriteString (perm.Name);

				writer.WriteRaw (jsonAllowedKey);
				writer.WriteBoolean (perm.PermissionLevel >= _context.PermissionLevel);

				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();
			
			writer.WriteEndObject ();
			
			WebUtils.SendEnvelopedResult (_context, ref writer);
		}
	}
}