using System.Collections.Generic;
using System.Text.RegularExpressions;
using JetBrains.Annotations;
using Platform.EOS;
using Platform.Steam;
using Webserver.Permissions;

namespace Webserver.Commands {
	[UsedImplicitly]
	public class CreateWebUser : ConsoleCmdAbstract {
		private static readonly Regex validNameTokenMatcher = new Regex (@"^\w+$");

		public override string[] GetCommands () {
			return new[] {"createwebuser"};
		}

		public override string GetDescription () {
			return "Create a web dashboard user account";
		}

		public override string GetHelp () {
			return ""; // TODO
		}

		public override int DefaultPermissionLevel => 1000;
		public override bool IsExecuteOnClient => true;

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			// if (GameManager.IsDedicatedServer) {
			// 	SdtdConsole.Instance.Output ("Command can only be executed on game clients or listen servers.");
			// 	return;
			// }
			
			// TODO
			
			if (_params.Count < 2) {
				SdtdConsole.Instance.Output ($"Wrong number of arguments");
				return;
			}

			string name = _params [0];
			string pass = _params [1];
			
			if (string.IsNullOrEmpty (name)) {
				SdtdConsole.Instance.Output ("Argument 'name' is empty.");
				return;
			}

			if (!validNameTokenMatcher.IsMatch (name)) {
				SdtdConsole.Instance.Output (
					"Argument 'name' may only contain characters (A-Z, a-z), digits (0-9) and underscores (_).");
				return;
			}

			if (string.IsNullOrEmpty (pass)) {
				SdtdConsole.Instance.Output ("Argument 'password' is empty.");
				return;
			}

			if (!validNameTokenMatcher.IsMatch (pass)) {
				SdtdConsole.Instance.Output (
					"Argument 'password' may only contain characters (A-Z, a-z), digits (0-9) and underscores (_).");
				return;
			}

			AdminWebUsers.Instance.AddUser (name, pass, new UserIdentifierSteam (76561198066968172ul),
				new UserIdentifierEos ("0002bc29a5624774b4b0dc27e60b974f"));

			SdtdConsole.Instance.Output ($"User added");
		}

	}
}