using System.Collections.Generic;
using JetBrains.Annotations;

namespace MapRendering.Commands {
	[UsedImplicitly]
	public class EnableRendering : ConsoleCmdAbstract {
		protected override string getDescription () {
			return "enable/disable live map rendering";
		}

		protected override string[] getCommands () {
			return new[] {"enablerendering"};
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			if (_params.Count != 1) {
				SdtdConsole.Instance.Output ($"Current state: {MapRenderer.renderingEnabled}");
				return;
			}

			MapRenderer.renderingEnabled = _params [0].Equals ("1");
			SdtdConsole.Instance.Output ($"Set live map rendering to {_params [0].Equals ("1")}");
		}
	}
}