using System.Collections.Generic;
using JetBrains.Annotations;

namespace Webserver.FileCache {
	[UsedImplicitly]
	public class InvalidateCachesCmd : ConsoleCmdAbstract {
		protected override string[] getCommands () {
			return new[] {"invalidatecaches"};
		}

		protected override string getDescription () {
			return "Invalidate contents of web file caches";
		}

		protected override string getHelp () {
			return "TODO";
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			(int files, int bytes) = AbstractCache.InvalidateAllCaches ();
			SdtdConsole.Instance.Output ($"Caches invalidated, dropped {files} files with {bytes} Bytes");
		}

	}
}