using System.Collections.Generic;
using JetBrains.Annotations;

namespace CommandExtensions.Commands {
	[UsedImplicitly]
	public class SayToPlayer : ConsoleCmdAbstract {
		protected override string getDescription () {
			return "send a message to a single player";
		}

		protected override string getHelp () {
			return "Usage:\n" +
			       "   pm <player name / steam id / entity id> <message>\n" +
			       "Send a PM to the player given by the player name or entity id (as given by e.g. \"lpi\").";
		}

		protected override string[] getCommands () {
			return new[] {"sayplayer", "pm"};
		}

		private void RunInternal (ClientInfo _sender, List<string> _params) {
			if (_params.Count < 2) {
				SdtdConsole.Instance.Output ("Usage: sayplayer <playername|entityid> <message>");
				return;
			}

			string message = _params [1];

			ClientInfo receiver = ConsoleHelper.ParseParamIdOrName (_params [0]);
			if (receiver != null) {
				ChatHelpers.SendMessage (receiver, _sender, message);
			} else {
				SdtdConsole.Instance.Output ("Playername or entity ID not found.");
			}
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			RunInternal (_senderInfo.RemoteClientInfo, _params);
		}
	}
}