using JetBrains.Annotations;
using Webserver;
using Webserver.UrlHandlers;

namespace MapRendering {
	[UsedImplicitly]
	public class ModApi : IModApi {
		public void InitMod (Mod _modInstance) {
			if (ConnectionManager.Instance.IsServer) {
				ModEvents.GameShutdown.RegisterHandler (GameShutdown);
				ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
			}
			
			Web.ServerInitialized += _web => {
				_web.RegisterPathHandler ("/map/", new StaticHandler (
					$"{GameIO.GetSaveGameDir ()}/map",
					MapRenderer.GetTileCache (),
					false,
					"web.map")
				);
			};
		}

		private void GameShutdown () {
			MapRenderer.Shutdown ();
		}

		private void CalcChunkColorsDone (Chunk _chunk) {
			MapRenderer.RenderSingleChunk (_chunk);
		}
	}
}