using System;
using System.Collections.Generic;
using System.Net;

namespace Webserver {
	public class ConnectionHandler {
		private readonly Dictionary<string, WebConnection> connections = new Dictionary<string, WebConnection> ();

		public WebConnection IsLoggedIn (string _sessionId, IPAddress _ip) {
			if (!connections.TryGetValue (_sessionId, out WebConnection con)) {
				return null;
			}

//			if (con.Age.TotalMinutes > parent.sessionTimeoutMinutes) {
//				connections.Remove (_sessionId);
//				return null;
//			}

			// if (!Equals (con.Endpoint, _ip)) { // reverse proxy = same source ip!!
			// 	connections.Remove (_sessionId);
			// 	return null;
			// }

			con.UpdateUsage ();

			return con;
		}

		public void LogOut (string _sessionId) {
			connections.Remove (_sessionId);
		}

		public WebConnection LogIn (IPAddress _ip, string _username, PlatformUserIdentifierAbs _userId, PlatformUserIdentifierAbs _crossUserId = null) {
			string sessionId = Guid.NewGuid ().ToString ();
			WebConnection con = new WebConnection (sessionId, _ip, _username, _userId, _crossUserId);
			connections.Add (sessionId, con);
			return con;
		}

		public void SendLine (string _line) {
			foreach (KeyValuePair<string, WebConnection> kvp in connections) {
				kvp.Value.SendLine (_line);
			}
		}
	}
}