using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs {
	[UsedImplicitly]
	public class WebMods : AbsRestApi {
		private readonly byte[] loadedWebMods;

		public WebMods (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginArray ();

			for (int i = 0; i < _parent.webMods.Count; i++) {
				WebMod webMod = _parent.webMods [i];
				
				if (i > 0) {
					writer.WriteValueSeparator ();
				}

				writer.WriteBeginObject ();

				writer.WriteString ("name");
				writer.WriteNameSeparator ();
				writer.WriteString (webMod.ParentMod.Name);

				string webModReactBundle = webMod.ReactBundle;
				if (webModReactBundle != null) {
					writer.WriteValueSeparator ();
					writer.WriteString ("bundle");
					writer.WriteNameSeparator ();
					writer.WriteString (webModReactBundle);
				}

				string webModCssFile = webMod.CssPath;
				if (webModCssFile != null) {
					writer.WriteValueSeparator ();
					writer.WriteString ("css");
					writer.WriteNameSeparator ();
					writer.WriteString (webModCssFile);
				}

				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();

			loadedWebMods = writer.ToUtf8ByteArray ();
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (loadedWebMods);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => 2000;
	}
}