﻿using System.Collections.Generic;
using JetBrains.Annotations;
using Utf8Json;
using Webserver.LiveData;

namespace Webserver.WebAPI.APIs {
	[UsedImplicitly]
	internal class Hostile : AbsRestApi {
		private readonly List<EntityEnemy> entities = new List<EntityEnemy> ();

		private static readonly byte[] jsonKeyId = JsonWriter.GetEncodedPropertyNameWithBeginObject ("id");
		private static readonly byte[] jsonKeyName = JsonWriter.GetEncodedPropertyNameWithBeginObject ("name");
		private static readonly byte[] jsonKeyPosition = JsonWriter.GetEncodedPropertyNameWithBeginObject ("position");

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteBeginArray ();
			
			lock (entities) {
				Hostiles.Instance.Get (entities);
				
				for (int i = 0; i < entities.Count; i++) {
					if (i > 0) {
						writer.WriteValueSeparator ();
					}
					
					EntityAlive entity = entities [i];
					Vector3i position = new Vector3i (entity.GetPosition ());
					
					writer.WriteRaw (jsonKeyId);
					writer.WriteInt32 (entity.entityId);
					
					writer.WriteRaw (jsonKeyName);
					writer.WriteString (!string.IsNullOrEmpty (entity.EntityName) ? entity.EntityName : $"enemy class #{entity.entityClass}");
					
					writer.WriteRaw (jsonKeyPosition);
					JsonCommons.WritePositionObject (ref writer, position);

					writer.WriteEndObject ();
				}
			}
			
			writer.WriteEndArray ();
			SendEnvelopedResult (_context, ref writer);
		}
	}
}
