namespace Webserver.WebAPI {
	public abstract class AbsWebAPI {
		public readonly string Name;
		protected readonly Web ParentWeb;

		protected AbsWebAPI (string _name = null) : this(null, _name) {
		}

		protected AbsWebAPI (Web _parentWeb, string _name = null) {
			Name = _name ?? GetType ().Name;
			ParentWeb = _parentWeb;
		}

		public abstract void HandleRequest (RequestContext _context);

		public virtual int DefaultPermissionLevel () => 0;
	}
}