using System.Net;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace MapRendering.Api {
	[UsedImplicitly]
	public class Map : AbsRestApi {

		private static readonly byte[] jsonEnabledKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("enabled");
		
		protected override void HandleRestGet (RequestContext _context) {
			string id = _context.RequestPath;
			
			PrepareEnvelopedResult (out JsonWriter writer);

			switch (id) {
				case "config":
					writer.WriteRaw (jsonEnabledKey);
					writer.WriteBoolean (MapRenderer.Enabled);
					writer.WriteEndObject ();
					break;
				default:
					SendErrorResult (_context, HttpStatusCode.NotImplemented, _errorCode: "INVALID_ID");
					return;
			}
			
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultMethodPermissionLevel (ERequestMethod _method) {
			return _method switch {
				ERequestMethod.GET => 2000,
				_ => base.DefaultMethodPermissionLevel (_method)
			};
		}
	}
}