using JetBrains.Annotations;
using Webserver;
using Webserver.UrlHandlers;

namespace MapRendering {
	[UsedImplicitly]
	public class ModApi : IModApi {
		public void InitMod (Mod _modInstance) {
			ModEvents.GameStartDone.RegisterHandler (GameStartDone);

			Web.ServerInitialized += _web => {
				if (!MapRenderer.Enabled) {
					return;
				}

				_web.RegisterPathHandler ("/map/", new StaticHandler (
					$"{GameIO.GetSaveGameDir ()}/map",
					MapRenderer.GetTileCache (),
					false,
					"web.map")
				);
			};
		}

		private void GameStartDone () {
			if (!MapRenderer.Enabled) {
				return;
			}

			ModEvents.GameShutdown.RegisterHandler (GameShutdown);
			ModEvents.CalcChunkColorsDone.RegisterHandler (CalcChunkColorsDone);
		}

		private void GameShutdown () {
			MapRenderer.Shutdown ();
		}

		private void CalcChunkColorsDone (Chunk _chunk) {
			MapRenderer.RenderSingleChunk (_chunk);
		}
	}
}
