using System;
using JetBrains.Annotations;
using UnityEngine;
using Utf8Json;
using Webserver.UrlHandlers;
using Webserver.WebAPI;

namespace Webserver.SSE {
	[UsedImplicitly]
	public class EventLog : AbsEvent {
		public EventLog (SseHandler _parent) : base (_parent, _name: "log") {
			Log.LogCallbacksExtended += LogCallback;
		}

		private static readonly byte[] jsonMsgKey = JsonWriter.GetEncodedPropertyNameWithBeginObject ("msg");
		private static readonly byte[] jsonTypeKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("type");
		private static readonly byte[] jsonTraceKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("trace");
		private static readonly byte[] jsonIsotimeKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("isotime");
		private static readonly byte[] jsonUptimeKey = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("uptime");

		private void LogCallback (string _formattedMsg, string _plainMsg, string _trace, LogType _type, DateTime _timestamp, long _uptime) {
			string uptime = _uptime.ToString ();

			JsonWriter writer = new JsonWriter ();
			
			writer.WriteRaw (jsonMsgKey);
			writer.WriteString (_plainMsg);
			
			writer.WriteRaw (jsonTypeKey);
			writer.WriteString (_type.ToStringCached ());
			
			writer.WriteRaw (jsonTraceKey);
			writer.WriteString (_trace);
			
			writer.WriteRaw (jsonIsotimeKey);
			JsonCommons.WriteDateTime (ref writer, _timestamp);
			
			writer.WriteRaw (jsonUptimeKey);
			writer.WriteString (uptime);
			
			writer.WriteEndObject ();
			
			SendData ("logLine", writer.ToString ());
		}
	}
}