using System;
using System.Collections.Generic;
using System.Net;
using UnityEngine;
using Webserver.Permissions;

namespace Webserver {
	public class WebConnection : ConsoleConnectionAbstract {
		private readonly DateTime login;
//		private readonly List<string> outputLines = new List<string> ();
		private DateTime lastAction;
		private readonly string conDescription;

		public string SessionID { get; }

		public IPAddress Endpoint { get; }

		public string Username { get; }
		public PlatformUserIdentifierAbs UserId { get; }
		public PlatformUserIdentifierAbs CrossplatformUserId { get; }

		public TimeSpan Age => DateTime.Now - lastAction;

		public WebConnection (string _sessionId, IPAddress _endpoint, string _username, PlatformUserIdentifierAbs _userId, PlatformUserIdentifierAbs _crossUserId = null) {
			SessionID = _sessionId;
			Endpoint = _endpoint;
			Username = _username;
			UserId = _userId;
			CrossplatformUserId = _crossUserId;
			login = DateTime.Now;
			lastAction = login;
			conDescription = $"WebPanel from {Endpoint}";
		}

		public void UpdateUsage () {
			lastAction = DateTime.Now;
		}

		public override string GetDescription () {
			return conDescription;
		}

		public override void SendLine (string _text) {
//			outputLines.Add (_text);
		}

		public override void SendLines (List<string> _output) {
//			outputLines.AddRange (_output);
		}

		public override void SendLog (string _formattedMsg, string _plainMsg, string _trace, LogType _type, DateTime _timestamp, long _uptime) {
			// Do nothing, handled by LogBuffer
		}
	}
}