using Webserver.Permissions;

namespace Webserver.UrlHandlers {
	public abstract class AbsHandler {
		protected readonly string moduleName;
		protected string urlBasePath;
		protected Web parent;

		public string ModuleName => moduleName;
		public string UrlBasePath => urlBasePath;

		protected AbsHandler (string _moduleName, int _defaultPermissionLevel = 0) {
			moduleName = _moduleName;
			AdminWebModules.Instance.AddKnownModule (new AdminWebModules.WebModule(_moduleName, _defaultPermissionLevel, true));
		}

		public abstract void HandleRequest (RequestContext _context);

		public virtual bool IsAuthorizedForHandler (WebConnection _user, int _permissionLevel) {
			return moduleName == null || AdminWebModules.Instance.ModuleAllowedWithLevel (moduleName, _permissionLevel);
		}

		public virtual void Shutdown () {
		}

		public virtual void SetBasePathAndParent (Web _parent, string _relativePath) {
			parent = _parent;
			urlBasePath = _relativePath;
		}
	}
}