using System.IO;
using Webserver.FileCache;
using Webserver.UrlHandlers;

namespace Webserver {
	public class WebMod {
		private const string modsBaseUrl = "/webmods/";
		private const string reactBundleName = "bundle.js";
		private const string stylingFileName = "styling.css";
		
		public readonly Mod ParentMod;
		public readonly string ReactBundle; // Absolute web path to the React bundle if the mod has one, e.g. "/webmods/myMod/bundle.js"
		public readonly string CssPath; // Absolute web path to a CSS if the mod has one, e.g. "/webmods/myMod/styling.css";
		public readonly bool IsWebMod;

		public WebMod (Web _parentWeb, Mod _parentMod, bool _useStaticCache) {
			ParentMod = _parentMod;

			string folder = $"{_parentMod.Path}/WebMod";
			IsWebMod = Directory.Exists (folder);

			if (IsWebMod) {
				string urlWebModBase = $"{modsBaseUrl}{_parentMod.FolderName}/";

				ReactBundle = $"{folder}/{reactBundleName}";
				ReactBundle = File.Exists (ReactBundle) ? $"{urlWebModBase}{reactBundleName}" : null;

				CssPath = $"{folder}/{stylingFileName}";
				CssPath = File.Exists (CssPath) ? $"{urlWebModBase}{stylingFileName}" : null;

				_parentWeb.RegisterPathHandler (urlWebModBase, new StaticHandler (
					folder,
					_useStaticCache ? new SimpleCache () : new DirectAccess (),
					false)
				);
			}
		}
	}
}