using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.GameData {
	[UsedImplicitly]
	public class Mods : AbsRestApi {
		private readonly byte[] loadedWebMods;

		public Mods (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginArray ();

			for (int i = 0; i < _parent.WebMods.Count; i++) {
				WebMod webMod = _parent.WebMods [i];

				if (i > 0) {
					writer.WriteValueSeparator ();
				}
				
				writer.WriteBeginObject ();

				writeModJson (ref writer, webMod);

				if (webMod.ReactBundle != null || webMod.CssPath != null) {
					writer.WriteValueSeparator ();

					writer.WritePropertyName ("web");
					writer.WriteBeginObject ();
					
					string webModReactBundle = webMod.ReactBundle;
					if (webModReactBundle != null) {
						writer.WritePropertyName ("bundle");
						writer.WriteString (webModReactBundle);
					}

					string webModCssFile = webMod.CssPath;
					if (webModCssFile != null) {
						if (webModReactBundle != null) {
							writer.WriteValueSeparator ();
						}

						writer.WritePropertyName ("css");
						writer.WriteString (webModCssFile);
					}
					
					writer.WriteEndObject ();
				}

				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();

			loadedWebMods = writer.ToUtf8ByteArray ();
		}

		private void writeModJson (ref JsonWriter _writer, WebMod _webMod) {
			_writer.WritePropertyName ("name");
			_writer.WriteString (_webMod.ParentMod.Name);
			
			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("displayName");
			_writer.WriteString (_webMod.ParentMod.DisplayName);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("description");
			_writer.WriteString (_webMod.ParentMod.Description);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("author");
			_writer.WriteString (_webMod.ParentMod.Author);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("version");
			_writer.WriteString (_webMod.ParentMod.VersionString);

			_writer.WriteValueSeparator ();
			_writer.WritePropertyName ("website");
			_writer.WriteString (_webMod.ParentMod.Website);
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (loadedWebMods);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}
