﻿using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.GameData {
	[UsedImplicitly]
	internal class Item : AbsRestApi {
		private static readonly byte[] jsonKeyName = JsonWriter.GetEncodedPropertyNameWithBeginObject ("name");
		private static readonly byte[] jsonKeyLocalizedName = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("localizedName");
		private static readonly byte[] jsonKeyIsBlock = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("isBlock");

		private readonly byte[] allItemsSerialized;

		public Item (Web _parent) {
			JsonWriter writer = new JsonWriter ();
			
			writer.WriteBeginArray ();

			int written = 0;
			for (int i = 0; i < ItemClass.list.Length; i++) {
				ItemClass item = ItemClass.list [i];
				if (item == null) {
					continue;
				}
				
				if (written > 0) {
					writer.WriteValueSeparator ();
				}

				written++;

				string name = item.Name;
				string localizedName = item.GetLocalizedItemName ();
				bool isBlock = item.IsBlock ();
				
				writer.WriteRaw (jsonKeyName);
				writer.WriteString (name);

				writer.WriteRaw (jsonKeyLocalizedName);
				writer.WriteString (localizedName);

				writer.WriteRaw (jsonKeyIsBlock);
				writer.WriteBoolean (isBlock);
				
				writer.WriteEndObject ();
			}

			writer.WriteEndArray ();

			allItemsSerialized = writer.ToUtf8ByteArray ();
		}

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			writer.WriteRaw (allItemsSerialized);
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}