using System.Collections.Generic;
using JetBrains.Annotations;
using Utf8Json;
using Webserver.Permissions;

namespace Webserver.WebAPI.APIs.ServerState {
	[UsedImplicitly]
	public class ServerInfo : AbsRestApi {
		private static readonly UnityEngine.Profiling.CustomSampler buildSampler = UnityEngine.Profiling.CustomSampler.Create ("JSON_ServerInfo_BuildSampler");

		private static readonly byte[] keyType = JsonWriter.GetEncodedPropertyNameWithBeginObject ("type");
		private static readonly byte[] keyValue = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("value");

		private int largestBuffer;

		protected override void HandleRestGet (RequestContext _context) {
			buildSampler.Begin ();

			PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.EnsureCapacity (largestBuffer);
			writer.WriteBeginObject ();
			
			GameServerInfo gsi = ConnectionManager.Instance.LocalServerInfo;

			bool first = true;

			IList<GameInfoString> list = EnumUtils.Values<GameInfoString> ();
			for (int i = 0; i < list.Count; i++) {
				GameInfoString stringGamePref = list [i];

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (stringGamePref.ToStringCached ());

				writer.WriteRaw (keyType);
				writer.WriteString ("string");

				writer.WriteRaw (keyValue);
				writer.WriteString (gsi.GetValue (stringGamePref));

				writer.WriteEndObject ();
			}

			IList<GameInfoInt> ints = EnumUtils.Values<GameInfoInt> ();
			for (int i = 0; i < ints.Count; i++) {
				GameInfoInt intGamePref = ints [i];

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (intGamePref.ToStringCached ());

				writer.WriteRaw (keyType);
				writer.WriteString ("int");

				writer.WriteRaw (keyValue);
				writer.WriteInt32 (gsi.GetValue (intGamePref));

				writer.WriteEndObject ();
			}

			IList<GameInfoBool> prefs = EnumUtils.Values<GameInfoBool> ();
			for (int i = 0; i < prefs.Count; i++) {
				GameInfoBool boolGamePref = prefs [i];

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (boolGamePref.ToStringCached ());

				writer.WriteRaw (keyType);
				writer.WriteString ("bool");

				writer.WriteRaw (keyValue);
				writer.WriteBoolean (gsi.GetValue (boolGamePref));

				writer.WriteEndObject ();
			}

			writer.WriteEndObject ();
			
			buildSampler.End ();

			int bufferContentSize = writer.CurrentOffset + 128;
			if (bufferContentSize > largestBuffer) {
				largestBuffer = bufferContentSize;
			}
			
			SendEnvelopedResult (_context, ref writer);
		}

		public override int DefaultPermissionLevel () => AdminWebModules.PermissionLevelGuest;
	}
}