using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs.ServerState {
	[UsedImplicitly]
	public class GameStats : AbsRestApi {
		private static readonly byte[] keyType = JsonWriter.GetEncodedPropertyNameWithBeginObject ("type");
		private static readonly byte[] keyValue = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("value");

		private int largestBuffer;

		protected override void HandleRestGet (RequestContext _context) {
			PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.EnsureCapacity (largestBuffer);
			writer.WriteBeginObject ();

			bool first = true;
			foreach (EnumGameStats stat in EnumUtils.Values<EnumGameStats> ()) {
				string name = stat.ToStringCached ();
				global::GameStats.EnumType? type = global::GameStats.GetStatType (stat);

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;
				
				writer.WritePropertyName (name);
				
				writer.WriteRaw (keyType);
				writer.WriteString (type.HasValue ? type.Value.ToStringCached () : "noType");
				
				writer.WriteRaw (keyValue);
				switch (type) {
					case global::GameStats.EnumType.Int:
						writer.WriteInt32 (global::GameStats.GetInt (stat));
						break;
					case global::GameStats.EnumType.Float:
						writer.WriteSingle (global::GameStats.GetFloat (stat));
						break;
					case global::GameStats.EnumType.String:
						writer.WriteString (global::GameStats.GetString (stat));
						break;
					case global::GameStats.EnumType.Bool:
						writer.WriteBoolean (global::GameStats.GetBool (stat));
						break;
					default:
						writer.WriteNull ();
						break;
				}
				
				writer.WriteEndObject ();
			}
			
			writer.WriteEndObject ();

			int bufferContentSize = writer.CurrentOffset + 128;
			if (bufferContentSize > largestBuffer) {
				largestBuffer = bufferContentSize;
			}
			
			SendEnvelopedResult (_context, ref writer);
		}
	}
}