using JetBrains.Annotations;
using Utf8Json;

namespace Webserver.WebAPI.APIs.WorldState {
	[UsedImplicitly]
	public class Bloodmoon : AbsRestApi {
		private static readonly byte[] jsonKeyGameTime = JsonWriter.GetEncodedPropertyNameWithBeginObject ("gameTime");
		private static readonly byte[] jsonKeyBloodmoonActive = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("bloodmoonActive");
		private static readonly byte[] jsonKeyNextBloodmoon = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("nextBloodmoon");
		private static readonly byte[] jsonKeyNextBloodmoonEnd = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("nextBloodmoonEnd");

		protected override void HandleRestGet (RequestContext _context) {
			ulong currentWorldTime = GameManager.Instance.World.worldTime;
			(int currentDay, int currentHour, int currentMinut) = GameUtils.WorldTimeToElements (currentWorldTime);

			int nextBloodmoonDay = GameStats.GetInt (EnumUtils.Parse<EnumGameStats> (nameof (EnumGameStats.BloodMoonDay)));

			(int duskHour, int dawnHour) duskDawnHours = GameUtils.CalcDuskDawnHours (GamePrefs.GetInt (EnumUtils.Parse<EnumGamePrefs> (nameof (EnumGamePrefs.DayLightLength))));

			PrepareEnvelopedResult (out JsonWriter writer);
			
			writer.WriteRaw (jsonKeyGameTime);
			JsonCommons.WriteGameTimeObject (ref writer, currentDay, currentHour, currentMinut);

			writer.WriteRaw (jsonKeyBloodmoonActive);
			writer.WriteBoolean (GameUtils.IsBloodMoonTime (currentWorldTime, duskDawnHours, nextBloodmoonDay));
			
			writer.WriteRaw (jsonKeyNextBloodmoon);
			JsonCommons.WriteGameTimeObject (ref writer, nextBloodmoonDay, duskDawnHours.duskHour, 0);
			
			writer.WriteRaw (jsonKeyNextBloodmoonEnd);
			JsonCommons.WriteGameTimeObject (ref writer, nextBloodmoonDay + 1, duskDawnHours.dawnHour, 0);
			
			writer.WriteEndObject ();

			SendEnvelopedResult (_context, ref writer);
		}
	}
}