using System.Collections.Generic;
using JetBrains.Annotations;

namespace MapRendering.Commands {
	[UsedImplicitly]
	public class RenderMap : ConsoleCmdAbstract {
		protected override string getDescription () {
			return "render the current map to a file";
		}

		protected override string[] getCommands () {
			return new[] {"rendermap"};
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			if (!MapRenderer.HasInstance) {
				SdtdConsole.Instance.Output ("Renderer not enabled");
				return;
			}
			
			MapRenderer.Instance.RenderFullMap ();

			SdtdConsole.Instance.Output ("Render map done");
		}
	}
}