using System;
using System.Collections.Generic;
using HarmonyLib;
using JetBrains.Annotations;

namespace Webserver {
	public static class UserRegistrationTokens {
		private const float tokenExpirationMinutes = 3;

		public class RegistrationData {
			public readonly string PlayerName;
			public readonly DateTime ExpiryTime;
			public readonly PlatformUserIdentifierAbs PlatformUserId;
			public readonly PlatformUserIdentifierAbs CrossPlatformUserId;

			public RegistrationData (string _playerName, PlatformUserIdentifierAbs _platformUserId, PlatformUserIdentifierAbs _crossPlatformUserId) {
				PlayerName = _playerName;
				ExpiryTime = DateTime.Now + TimeSpan.FromMinutes (tokenExpirationMinutes);
				PlatformUserId = _platformUserId;
				CrossPlatformUserId = _crossPlatformUserId;
			}
		}

		public static bool TryValidate (string _token, out RegistrationData _data) {
			return activeTokens.TryGetValue (_token, out _data) && _data.ExpiryTime > DateTime.Now;
		}

		private static readonly Dictionary<string, RegistrationData> activeTokens = new Dictionary<string, RegistrationData> ();

		[HarmonyPatch(typeof(ConsoleCmdCreateWebUser))]
		[HarmonyPatch("createToken")]
		private class CommandPatch {
			[UsedImplicitly]
			private static bool Prefix (ref string __result, string _playerName, PlatformUserIdentifierAbs _platformUserId, PlatformUserIdentifierAbs _crossPlatformUserId) {
				string token = Utils.GenerateGuid ();

				bool hasCrossplatformId = _crossPlatformUserId != null;
				DateTime currentTime = DateTime.Now;
				
				// Check if the user already has a registration attempt running and if so delete the old one
				// Also clear out any expired tokens
				activeTokens.RemoveAll (_data => _data.ExpiryTime < currentTime || _platformUserId.Equals (_data.PlatformUserId) ||
				                                 (hasCrossplatformId && _crossPlatformUserId.Equals (_data.CrossPlatformUserId)));
				
				RegistrationData data = new RegistrationData (_playerName, _platformUserId, _crossPlatformUserId);
				activeTokens [token] = data;
				
				__result = token;
				return false;
			}
		}
		
	}
}