using System;
using System.Net;

namespace Webserver.WebAPI.APIs.Permissions {
	public static class PermissionsApiHelpers {
		public static bool TryParseId (RequestContext _context, byte[] _jsonInputData, out PlatformUserIdentifierAbs _userId,
			out string _groupId) {
			string id = _context.RequestPath;
			_userId = default;
			_groupId = default;

			if (string.IsNullOrEmpty (id)) {
				WebUtils.SendEmptyResponse (_context, HttpStatusCode.BadRequest, _jsonInputData, "NO_USER_OR_GROUP");
				return false;
			}

			const string kindUserPrefix = "user/";
			if (id.StartsWith (kindUserPrefix, StringComparison.Ordinal)) {
				bool validId = PlatformUserIdentifierAbs.TryFromCombinedString (id.Substring (kindUserPrefix.Length), out _userId);
				if (!validId) {
					WebUtils.SendEmptyResponse (_context, HttpStatusCode.BadRequest, _jsonInputData, "INVALID_USER");
				}

				return validId;
			}

			const string kindGroupPrefix = "group/";
			if (id.StartsWith (kindGroupPrefix, StringComparison.Ordinal)) {
				_groupId = id.Substring (kindGroupPrefix.Length);
				bool validId = _groupId.Length > 0;
				if (!validId) {
					WebUtils.SendEmptyResponse (_context, HttpStatusCode.BadRequest, _jsonInputData, "INVALID_GROUP");
				}

				return validId;
			}

			WebUtils.SendEmptyResponse (_context, HttpStatusCode.BadRequest, _jsonInputData, "INVALID_KIND");
			return false;
		}
	}
}