using Webserver.Permissions;

namespace Webserver.WebAPI {
	public abstract class AbsWebAPI {
		public readonly string Name;
		protected readonly Web ParentWeb;

		protected readonly string CachedApiModuleName;

		protected AbsWebAPI (string _name = null) : this(null, _name) {
		}

		protected AbsWebAPI (Web _parentWeb, string _name = null) {
			Name = _name ?? GetType ().Name;
			ParentWeb = _parentWeb;
			CachedApiModuleName = $"webapi.{Name}";
			RegisterPermissions ();
		}

		protected virtual void RegisterPermissions () {
			AdminWebModules.Instance.AddKnownModule (new AdminWebModules.WebModule(CachedApiModuleName, DefaultPermissionLevel (), true));
		}

		public abstract void HandleRequest (RequestContext _context);

		public virtual bool Authorized (RequestContext _context) {
			return AdminWebModules.Instance.GetModule (CachedApiModuleName).LevelGlobal >= _context.PermissionLevel;
		}

		public virtual int DefaultPermissionLevel () => 0;
	}
}