using Webserver.Permissions;

namespace Webserver.UrlHandlers {
	public abstract class AbsHandler {
		public readonly string ModuleName;
		protected string urlBasePath;
		protected Web parent;

		public string UrlBasePath => urlBasePath;

		protected AbsHandler (string _moduleName, int _defaultPermissionLevel = 0) {
			ModuleName = _moduleName;
			AdminWebModules.Instance.AddKnownModule (new AdminWebModules.WebModule(_moduleName, _defaultPermissionLevel, true));
		}

		public abstract void HandleRequest (RequestContext _context);

		public virtual bool IsAuthorizedForHandler (RequestContext _context) {
			return ModuleName == null || AdminWebModules.Instance.ModuleAllowedWithLevel (ModuleName, _context.PermissionLevel);
		}

		public virtual void Shutdown () {
		}

		public virtual void SetBasePathAndParent (Web _parent, string _relativePath) {
			parent = _parent;
			urlBasePath = _relativePath;
		}
	}
}