using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using Webserver;
using Webserver.Permissions;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	public class GetPlayersLocation : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			AdminTools admTools = GameManager.Instance.adminTools;
			PlatformUserIdentifierAbs userId = _context.Connection?.UserId;

			bool listOffline = false;
			if (_context.Request.QueryString ["offline"] != null) {
				bool.TryParse (_context.Request.QueryString ["offline"], out listOffline);
			}

			bool bViewAll = PermissionUtils.CanViewAllPlayers (_context.PermissionLevel);

			JSONArray playersJsResult = new JSONArray ();

			Players playersList = PersistentContainer.Instance.Players;

			foreach (KeyValuePair<PlatformUserIdentifierAbs, Player> kvp in playersList.Dict) {
				if (admTools != null) {
					if (admTools.Blacklist.IsBanned (kvp.Key, out _, out _)) {
						continue;
					}
				}

				Player p = kvp.Value;

				if (listOffline || p.IsOnline) {
					if (bViewAll || p.InternalId.Equals (userId)) {
						JSONObject pos = new JSONObject ();
						pos.Add ("x", new JSONNumber (p.LastPosition.x));
						pos.Add ("y", new JSONNumber (p.LastPosition.y));
						pos.Add ("z", new JSONNumber (p.LastPosition.z));

						JSONObject pJson = new JSONObject ();
						pJson.Add ("steamid", new JSONString (kvp.Value.PlatformId.CombinedString));
						pJson.Add ("crossplatformid", new JSONString (kvp.Value.CrossPlatformId?.CombinedString ?? ""));

						//					pJson.Add("entityid", new JSONNumber (p.EntityID));
						//                    pJson.Add("ip", new JSONString (p.IP));
						pJson.Add ("name", new JSONString (p.Name));
						pJson.Add ("online", new JSONBoolean (p.IsOnline));
						pJson.Add ("position", pos);

						//					pJson.Add ("totalplaytime", new JSONNumber (p.TotalPlayTime));
						//					pJson.Add ("lastonline", new JSONString (p.LastOnline.ToString ("s")));
						//					pJson.Add ("ping", new JSONNumber (p.IsOnline ? p.ClientInfo.ping : -1));

						playersJsResult.Add (pJson);
					}
				}
			}

			LegacyApiHelper.WriteJSON (_context.Response, playersJsResult);
		}
	}
}