using System;
using System.IO;
using Webserver;
using Webserver.FileCache;
using Webserver.UrlHandlers;

namespace AllocsFixes {
	public class API : IModApi {
		private Mod modInstance;
		
		public void InitMod (Mod _modInstance) {
			modInstance = _modInstance;

			Web.ServerInitialized += _web => {
				try {
					const string legacyModUrl = "/legacymap";
					const string legacyFilesFoldername = "webserver_legacy";
					string legacyFilePath = $"{modInstance.Path}/{legacyFilesFoldername}";
				
					if (!Directory.Exists (legacyFilePath)) {
						Log.Out ($"Legacy webmod feature not started (folder \"{legacyFilesFoldername}\" not found in Allocs_WebAndMapRendering mod folder)");
						return;
					}

					// TODO: Read from config
					bool useStaticCache = false;

					_web.RegisterPathHandler ("/legacymap.htm", new SimpleRedirectHandler ($"{legacyModUrl}/index.html"));
					_web.RegisterPathHandler ($"{legacyModUrl}/", new StaticHandler (legacyFilePath, useStaticCache ? (AbstractCache) new SimpleCache () : new DirectAccess (), false));

					int webPort = GamePrefs.GetInt (EnumUtils.Parse<EnumGamePrefs> (nameof (EnumGamePrefs.WebDashboardPort)));
					Log.Out ($"Started legacy webmod feature on port {webPort}, local adress {legacyModUrl}");
				} catch (Exception e) {
					Log.Out ("Error in Web.ctor: " + e);
				}
			};
		}

		// public static void SetResponseTextContent (HttpListenerResponse _context.Response, string _text) {
		// 	byte[] buf = Encoding.UTF8.GetBytes (_text);
		// 	_context.Response.ContentLength64 = buf.Length;
		// 	_context.Response.ContentType = "text/html";
		// 	_context.Response.ContentEncoding = Encoding.UTF8;
		// 	_context.Response.OutputStream.Write (buf, 0, buf.Length);
		// }

		
	}
}