using System.Collections.Generic;
using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	public class GetPlayerInventories : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			GetPlayerInventory.GetInventoryArguments (_context, out bool showIconColor, out bool showIconName);

			JSONArray AllInventoriesResult = new JSONArray ();

			foreach (KeyValuePair<PlatformUserIdentifierAbs, Player> kvp in PersistentContainer.Instance.Players.Dict) {
				Player p = kvp.Value;

				if (p == null) {
					continue;
				}

				if (p.IsOnline) {
					AllInventoriesResult.Add (GetPlayerInventory.DoPlayer (p, showIconColor, showIconName));
				}
			}

			LegacyApiHelper.WriteJSON (_context.Response, AllInventoriesResult);
		}
	}
}