using AllocsFixes.JSON;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	public class GetAllowedCommands : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			JSONObject result = new JSONObject ();
			JSONArray entries = new JSONArray ();
			foreach (IConsoleCommand cc in SdtdConsole.Instance.GetCommands ()) {
				int commandPermissionLevel = GameManager.Instance.adminTools.Commands.GetCommandPermissionLevel (cc.GetCommands ());
				if (_context.PermissionLevel <= commandPermissionLevel) {
					string cmd = string.Empty;
					foreach (string s in cc.GetCommands ()) {
						if (s.Length > cmd.Length) {
							cmd = s;
						}
					}

					JSONObject cmdObj = new JSONObject ();
					cmdObj.Add ("command", new JSONString (cmd));
					cmdObj.Add ("description", new JSONString (cc.GetDescription ()));
					cmdObj.Add ("help", new JSONString (cc.GetHelp ()));
					entries.Add (cmdObj);
				}
			}

			result.Add ("commands", entries);

			LegacyApiHelper.WriteJSON (_context.Response, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}