using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	public class GetStats : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			JSONObject result = new JSONObject ();

			JSONObject time = new JSONObject ();
			time.Add ("days", new JSONNumber (GameUtils.WorldTimeToDays (GameManager.Instance.World.worldTime)));
			time.Add ("hours", new JSONNumber (GameUtils.WorldTimeToHours (GameManager.Instance.World.worldTime)));
			time.Add ("minutes", new JSONNumber (GameUtils.WorldTimeToMinutes (GameManager.Instance.World.worldTime)));
			result.Add ("gametime", time);

			result.Add ("players", new JSONNumber (GameManager.Instance.World.Players.Count));
			result.Add ("hostiles", new JSONNumber (Hostiles.Instance.GetCount ()));
			result.Add ("animals", new JSONNumber (Animals.Instance.GetCount ()));

			LegacyApiHelper.WriteJSON (_context.Response, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}