using System.Collections.Generic;
using AllocsFixes.JSON;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	public class GetLog : AbsWebAPI {
		private const int MAX_COUNT = 1000;
		
		public override void HandleRequest (RequestContext _context) {
			if (_context.Request.QueryString ["count"] == null || !int.TryParse (_context.Request.QueryString ["count"], out var count)) {
				count = 50;
			}

			if (count == 0) {
				count = 1;
			}

			if (count > MAX_COUNT) {
				count = MAX_COUNT;
			}

			if (count < -MAX_COUNT) {
				count = -MAX_COUNT;
			}

			if (_context.Request.QueryString ["firstLine"] == null || !int.TryParse (_context.Request.QueryString ["firstLine"], out var firstLine)) {
				if (count > 0) {
					firstLine = LogBuffer.Instance.OldestLine;
				} else {
					firstLine = LogBuffer.Instance.LatestLine;
				}
			}

			JSONObject result = new JSONObject ();

			List<LogBuffer.LogEntry> logEntries = LogBuffer.Instance.GetRange (ref firstLine, count, out var lastLine);

			JSONArray entries = new JSONArray ();
			foreach (LogBuffer.LogEntry logEntry in logEntries) {
				JSONObject entry = new JSONObject ();
				var logEntryTimestamp = logEntry.Timestamp;
				entry.Add ("date", new JSONString ($"{logEntryTimestamp.Year:0000}-{logEntryTimestamp.Month:00}-{logEntryTimestamp.Day:00}"));
				entry.Add ("time", new JSONString ($"{logEntryTimestamp.Hour:00}:{logEntryTimestamp.Minute:00}:{logEntryTimestamp.Second:00}"));
				entry.Add ("uptime", new JSONString (logEntry.Uptime.ToString()));
				entry.Add ("msg", new JSONString (logEntry.Message));
				entry.Add ("trace", new JSONString (logEntry.Trace));
				entry.Add ("type", new JSONString (logEntry.Type.ToStringCached ()));
				entries.Add (entry);
			}

			result.Add ("firstLine", new JSONNumber (firstLine));
			result.Add ("lastLine", new JSONNumber (lastLine));
			result.Add ("entries", entries);

			LegacyApiHelper.WriteJSON (_context.Response, result);
		}
	}
}