using AllocsFixes.LiveData;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	public class GetStats : AbsWebAPI {
		private static readonly byte[] jsonKeyGameTime = JsonWriter.GetEncodedPropertyNameWithBeginObject ("gametime");
		
		private static readonly byte[] jsonKeyPlayers = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("players");
		private static readonly byte[] jsonKeyHostiles = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("hostiles");
		private static readonly byte[] jsonKeyAnimals = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("animals");

		public override void HandleRequest (RequestContext _context) {
			JsonWriter writer = new JsonWriter ();
	
			writer.WriteRaw (jsonKeyGameTime);
			(int days, int hours, int minutes) = GameUtils.WorldTimeToElements (GameManager.Instance.World.worldTime);
			JsonCommons.WriteGameTimeObject (ref writer, days, hours, minutes);
			
			writer.WriteRaw (jsonKeyPlayers);
			writer.WriteInt32 (GameManager.Instance.World.Players.Count);
			
			writer.WriteRaw (jsonKeyHostiles);
			writer.WriteInt32 (Hostiles.Instance.GetCount ());
			
			writer.WriteRaw (jsonKeyAnimals);
			writer.WriteInt32 (Animals.Instance.GetCount ());
			
			writer.WriteEndObject ();
			
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}