using AllocsFixes.LiveData;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	public class GetWebUIUpdates : AbsWebAPI {
		private static readonly byte[] jsonKeyGameTime = JsonWriter.GetEncodedPropertyNameWithBeginObject ("gametime");
		
		private static readonly byte[] jsonKeyPlayers = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("players");
		private static readonly byte[] jsonKeyHostiles = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("hostiles");
		private static readonly byte[] jsonKeyAnimals = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("animals");
		private static readonly byte[] jsonKeyNewLogs = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("newlogs");

		public override void HandleRequest (RequestContext _context) {
			int latestLine;
			if (_context.Request.QueryString ["latestLine"] == null ||
			    !int.TryParse (_context.Request.QueryString ["latestLine"], out latestLine)) {
				latestLine = 0;
			}

			JsonWriter writer = new JsonWriter ();

			writer.WriteRaw (jsonKeyGameTime);
			(int days, int hours, int minutes) = GameUtils.WorldTimeToElements (GameManager.Instance.World.worldTime);
			JsonCommons.WriteGameTimeObject (ref writer, days, hours, minutes);
			
			writer.WriteRaw (jsonKeyPlayers);
			writer.WriteInt32 (GameManager.Instance.World.Players.Count);
			
			writer.WriteRaw (jsonKeyHostiles);
			writer.WriteInt32 (Hostiles.Instance.GetCount ());
			
			writer.WriteRaw (jsonKeyAnimals);
			writer.WriteInt32 (Animals.Instance.GetCount ());
			
			writer.WriteRaw (jsonKeyNewLogs);
			writer.WriteInt32 (LogBuffer.Instance.LatestLine - latestLine);
			
			writer.WriteEndObject ();
			
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}