using System;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	public class GetServerInfo : AbsWebAPI {
		private static readonly byte[] jsonKeyType = JsonWriter.GetEncodedPropertyNameWithBeginObject ("type");
		private static readonly byte[] jsonKeyValue = JsonWriter.GetEncodedPropertyNameWithPrefixValueSeparator ("value");

		public override void HandleRequest (RequestContext _context) {
			GameServerInfo gsi = ConnectionManager.Instance.LocalServerInfo;

			JsonWriter writer = new JsonWriter ();
			writer.WriteBeginObject ();

			bool first = true;

			foreach (string stringGamePref in Enum.GetNames (typeof (GameInfoString))) {
				string value = gsi.GetValue ((GameInfoString) Enum.Parse (typeof (GameInfoString), stringGamePref));
				
				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (stringGamePref);
				writer.WriteRaw (jsonKeyType);
				writer.WriteString ("string");
				
				writer.WriteRaw (jsonKeyValue);
				writer.WriteString (value);
				
				writer.WriteEndObject ();
			}

			foreach (string intGamePref in Enum.GetNames (typeof (GameInfoInt))) {
				int value = gsi.GetValue ((GameInfoInt) Enum.Parse (typeof (GameInfoInt), intGamePref));

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (intGamePref);
				writer.WriteRaw (jsonKeyType);
				writer.WriteString ("int");
				
				writer.WriteRaw (jsonKeyValue);
				writer.WriteInt32 (value);
				
				writer.WriteEndObject ();
			}

			foreach (string boolGamePref in Enum.GetNames (typeof (GameInfoBool))) {
				bool value = gsi.GetValue ((GameInfoBool) Enum.Parse (typeof (GameInfoBool), boolGamePref));

				if (!first) {
					writer.WriteValueSeparator ();
				}

				first = false;

				writer.WritePropertyName (boolGamePref);
				writer.WriteRaw (jsonKeyType);
				writer.WriteString ("bool");
				
				writer.WriteRaw (jsonKeyValue);
				writer.WriteBoolean (value);
				
				writer.WriteEndObject ();
			}
			
			writer.WriteEndObject ();
			
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}
	}
}