using System.Collections.Generic;
using AllocsFixes.PersistentData;
using JetBrains.Annotations;
using Utf8Json;
using Webserver;
using Webserver.WebAPI;

namespace AllocsFixes.WebAPIs {
	[UsedImplicitly]
	public class GetPlayerInventories : AbsWebAPI {
		public override void HandleRequest (RequestContext _context) {
			GetPlayerInventory.GetInventoryArguments (_context, out bool showIconColor, out bool showIconName);

			JsonWriter writer = new JsonWriter ();
			
			writer.WriteBeginArray ();
			
			bool first = true;

			foreach (KeyValuePair<PlatformUserIdentifierAbs, Player> kvp in PersistentContainer.Instance.Players.Dict) {
				Player p = kvp.Value;

				if (p == null) {
					continue;
				}

				if (p.IsOnline) {
					if (!first) {
						writer.WriteValueSeparator ();
					}

					first = false;
				
					GetPlayerInventory.DoPlayer (ref writer, p, showIconColor, showIconName);
				}
			}
			
			writer.WriteEndArray ();
			
			WebUtils.WriteJsonData (_context.Response, ref writer);
		}
	}
}