using System.Net;
using JetBrains.Annotations;
using Webserver;
using Webserver.UrlHandlers;
using Webserver.WebAPI;

namespace AllocsFixes.Web {
	[UsedImplicitly]
	public class SteamLoginApi : AbsWebAPI {
		public override int DefaultPermissionLevel () => 2000;

		private const string pageBasePath = "/legacymap/index.html";

		private const string steamOpenIdVerifyUrl = "verifysteamopenid";
		private const string steamLoginUrl = "loginsteam";
		
		public SteamLoginApi (Webserver.Web _parentWeb) : base(_parentWeb) {
		}

		public override void HandleRequest (RequestContext _context) {
			if (_context.Request.RemoteEndPoint == null) {
				WebUtils.WriteText (_context.Response, "No remote endpoint", HttpStatusCode.BadRequest);
				return;
			}

			string subpath = _context.RequestPath;
			
			string remoteEndpointString = _context.Request.RemoteEndPoint!.ToString ();
			
			if (subpath.StartsWith (steamOpenIdVerifyUrl)) {
				if (SessionHandler.HandleSteamVerification (ParentWeb.ConnectionHandler, _context, remoteEndpointString)) {
					_context.Response.Redirect (pageBasePath);
				} else {
					WebUtils.WriteText (_context.Response, "Login failed", HttpStatusCode.InternalServerError);
				}
				return;
			}
			
			if (subpath.StartsWith ("logout")) {
				SessionHandler.HandleLogout (ParentWeb.ConnectionHandler, _context, pageBasePath);
				return;
			}
			
			if (subpath.StartsWith (steamLoginUrl)) {
				string absoluteUrl = _context.Request.Url.AbsolutePath;
				absoluteUrl = absoluteUrl.Substring (0, absoluteUrl.Length - _context.RequestPath.Length);
				SessionHandler.HandleSteamLogin (_context, $"{absoluteUrl}{steamOpenIdVerifyUrl}");
				return;
			}

			WebUtils.WriteText (_context.Response, "Invalid path", HttpStatusCode.BadRequest);
		}

	}
}